﻿<?php
include ('last_db_config.php');

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['student_id']) && !empty($_POST['student_id'])) {

    $student_id = intval($_POST['student_id']);
    $evaluator = $_POST['name'];
    
    $merge = isset($_POST['merge']) ? intval($_POST['merge']) : 0;
    $disability = isset($_POST['disability']) ? $_POST['disability'] : '';

    $grades = [];
    $total = 0;

    for ($i = 1; $i <= 13; $i++) {
        if (isset($_POST["q$i"]) && $_POST["q$i"] !== '') {
            $grade = intval($_POST["q$i"]);
            $grades[$i] = $grade;
            $total += $grade;
        } else {
            $grades[$i] = NULL;  // هنا نحفظ NULL لو الدرجة مش مدخلة
        }
    }

    $stmt = $conn->prepare("INSERT INTO testresult 
        (StudentID, Evaluator, Q1, Q2, Q3, Q4, Q5, Q6, Q7, Q8, Q9, Q10, Q11, Q12, Q13, Total_Score) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ON DUPLICATE KEY UPDATE 
        Q1=VALUES(Q1), Q2=VALUES(Q2), Q3=VALUES(Q3), Q4=VALUES(Q4), Q5=VALUES(Q5),
        Q6=VALUES(Q6), Q7=VALUES(Q7), Q8=VALUES(Q8), Q9=VALUES(Q9), Q10=VALUES(Q10),
        Q11=VALUES(Q11), Q12=VALUES(Q12), Q13=VALUES(Q13), Total_Score=VALUES(Total_Score)");

    if ($stmt === false) {
        http_response_code(500);
        echo "خطأ في الاستعلام: " . $conn->error;
        exit();
    }

    $stmt->bind_param(
        "isiiiiiiiiiiiiii",
        $student_id,
        $evaluator,
        $grades[1],
        $grades[2],
        $grades[3],
        $grades[4],
        $grades[5],
        $grades[6],
        $grades[7],
        $grades[8],
        $grades[9],
        $grades[10],
        $grades[11],
        $grades[12],
        $grades[13],
        $total
    );

    if ($stmt->execute()) {

    // تحديث حالة التقييم
    $update_stmt = $conn->prepare("UPDATE student SET evaluated = 1 WHERE StudentID = ?");
    if ($update_stmt) {
        $update_stmt->bind_param("i", $student_id);
        $update_stmt->execute();
        $update_stmt->close();
    }

    // ✅ إذا الطالب دمج، نحفظ بيانات الدمج في جدول الطالب
    if ($merge === 1) {
        $merge_stmt = $conn->prepare("UPDATE student SET merge_flag = 1, disability_type = ? WHERE StudentID = ?");
        if ($merge_stmt) {
            $merge_stmt->bind_param("si", $disability, $student_id);
            $merge_stmt->execute();
            $merge_stmt->close();
        }
    } else {
        // في حالة الطالب عادي، نعيد الحقول إلى القيم الافتراضية
        $normal_stmt = $conn->prepare("UPDATE student SET merge_flag = 0, disability_type = NULL WHERE StudentID = ?");
        if ($normal_stmt) {
            $normal_stmt->bind_param("i", $student_id);
            $normal_stmt->execute();
            $normal_stmt->close();
        }
    }

    echo "success";
    } else {
        http_response_code(500);
        echo "خطأ أثناء التنفيذ: " . $stmt->error;
    }

    $stmt->close();
    $conn->close();

} else {
    http_response_code(400);
    echo "بيانات غير صالحة!";
}
?>
