<?php
header("Content-Type: text/html; charset=UTF-8");
include('last_db_config.php');
$govs = $conn->query("SELECT GovID, GovName FROM government");
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>تسجيل جديد - نظام التقييم</title>
  <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="main-style.css">
</head>
<body class="registration-page">
  <header class="program-header">
    <div class="header-content">
      <img src="wezara.png" alt="شعار الوزارة" class="logo-right">
      <div class="title-container">
        <h1 class="program-title">البرنامج القومي لتنمية مهارات اللغة العربية بالحلقة الابتدائية</h1>
      </div>
      <img src="week.png" alt="شعار البرنامج" class="logo-left">
    </div>
  </header>

  <main class="main-content">
    <div class="container">
      <div class="card">
        <div class="card-header">
          <h2>تسجيل بيانات المطبق</h2>
        </div>
        
        <div class="card-body">
          <form action="new_register_save.php" method="POST" onsubmit="return validateForm()">
            <div class="form-group">
              <label for="full_name">الاسم رباعي</label>
              <input type="text" id="full_name" name="full_name" class="form-control" required>
              <small id="name_error" class="error-message">يرجى إدخال الاسم رباعي.</small>
            </div>

            <div class="form-group">
              <label for="national_id">الرقم القومي</label>
              <input type="text" id="national_id" name="national_id" class="form-control" maxlength="14" pattern="\d{14}" required>
              <small id="nid_error" class="error-message">الرقم القومي يجب أن يكون 14 رقمًا.</small>
            </div>

            <div class="form-group">
              <label for="governorate">المحافظة</label>
              <select id="governorate" name="governorate_id" class="form-control" required>
                <option value="">-- اختر المحافظة --</option>
                <?php while($row = $govs->fetch_assoc()): ?>
                  <option value="<?= $row['GovID'] ?>"><?= $row['GovName'] ?></option>
                <?php endwhile; ?>
              </select>
            </div>

            <div class="form-group">
              <label for="admin">الإدارة التعليمية التي يعمل بها المطبق</label>
              <select id="admin" name="admin_id" class="form-control" required>
                <option value="">-- اختر الإدارة التعليمية --</option>
              </select>
            </div>

            <button type="submit" class="btn">تسجيل</button>
          </form>
        </div>
      </div>
    </div>
  </main>

  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script>
  $('#governorate').change(function() {
    var govId = $(this).val();
    $.post('action copy.php', { GovID: govId }, function(data) {
      $('#admin').html(data);
    });
  });

  document.getElementById('full_name').addEventListener('blur', function() {
    var fullName = this.value.trim();
    var nameError = document.getElementById('name_error');
    var nameParts = fullName.split(/\s+/);
    nameError.style.display = nameParts.length < 4 ? "block" : "none";
  });

  document.getElementById('national_id').addEventListener('input', function() {
    var nid = this.value.trim();
    var nidError = document.getElementById('nid_error');
    nidError.style.display = !/^\d{14}$/.test(nid) ? "block" : "none";
  });

  function validateForm() {
    var fullName = document.getElementById('full_name').value.trim();
    var nationalId = document.getElementById('national_id').value.trim();
    var valid = true;

    if (fullName.split(/\s+/).length < 4) {
      document.getElementById('name_error').style.display = "block";
      valid = false;
    }

    if (!/^\d{14}$/.test(nationalId)) {
      document.getElementById('nid_error').style.display = "block";
      valid = false;
    }

    return valid;
  }
  </script>
</body>
</html>