<?php
session_start();
include 'db_connection.php'; // Ensure DB connection is included

// ✅ Retrieve values correctly from session
$monitor_name = isset($_SESSION['monitor_name']) ? $_SESSION['monitor_name'] : '';  
$id = isset($_SESSION['id']) ? $_SESSION['id'] : '';  // Auto-incremented database ID
$school_id = isset($_SESSION['SchoolID']) ? $_SESSION['SchoolID'] : '';  // SchoolID from form input

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $forms = isset($_POST['forms']) ? $_POST['forms'] : "";
    $sounds = isset($_POST['sounds']) ? $_POST['sounds'] : "";
    $position = isset($_POST['position']) ? $_POST['position'] : "";
    $words = isset($_POST['words']) ? $_POST['words'] : "";
    $writing = isset($_POST['writing']) ? $_POST['writing'] : "";
    $formation = isset($_POST['formation']) ? $_POST['formation'] : "";
    $teacher_1 = $_POST['teacher_1'];
    
    // Handle checkbox responses properly
    $strategies = isset($_POST['strategies']) ? implode(", ", (array)$_POST['strategies']) : "";
    $games = isset($_POST['games']) ? implode(", ", (array)$_POST['games']) : "";
    $activities = isset($_POST['activities']) ? implode(", ", (array)$_POST['activities']) : "";
    $tools = isset($_POST['tools']) ? implode(", ", (array)$_POST['tools']) : "";

    // ✅ Debugging: Check retrieved session values
    echo "Retrieved Session Data:<br>";
    var_dump($_SESSION);

    // Insert into database
    $query = "INSERT INTO quality_control_tech2 (SchoolID, forms, sounds, position, words, writing, formation, strategies, games, activities, tools, Rid, monitor_nameQC, teacher_1)
              VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    $stmt = $conn->prepare($query);
    if (!$stmt) {
        die("Error preparing statement: " . $conn->error);
    }

    // ✅ Use correct variables and insert both `SchoolID` (from input) and `id` (from database)
    $stmt->bind_param("issssssssssiss", 
        $school_id, $forms, $sounds, $position, $words, $writing, $formation, 
        $strategies, $games, $activities, $tools, $id, $monitor_name, $teacher_1
    );

    if ($stmt->execute()) {
      header("Location: log.html");
      exit();
  } else {
      echo "Error saving data: " . $stmt->error;
  }

    $stmt->close();
}

$schools = mysqli_query($conn, "SELECT * FROM schoolsdata");
?>


   
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title> المعلم الثانى   </title>
  <link rel="stylesheet" href="styles1.css">
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.0/jquery.min.js"></script>

</head>

<body>
<form method="POST">

  
  <div class="container">
    <h1>البرنامج القومي لتنمية مهارات القراءة والكتابة بالحلقة الابتدائية
        <p>استمارة ضبط الجودة والدعم الفني</p></h1>
    
        <form action="" method="post" >
      
          
    <!-- المحور الثاني: الممارسات التدريسية -->
    <fieldset >
        <div>
         <label>أسم المعلم الثانى المستهدف بالزيارة الحالية:</label>
        <input type="text" name="teacher_1" placeholder="المعلم (1)">
        </div>
        <legend>المحور الثاني : الممارسات التدريسية</legend>
        <h3>هل قام/ يقوم المعلم بالممارسات التدريسية التالية:</h3>
        <ul >
        <div >
        
         <li> <label>تدريس الأشكال المتنوعة للحروف (أ -ب- ت -ث):</label></li>
          <input type="radio" id="forms_yes" name="forms" value="نعم">
          <label for="forms_yes" class="inline">نعم</label>
          <input type="radio" id="forms_no" name="forms" value="لا">
          <label for="forms_no" class="inline">لا</label>
        </div>
        
        <div >
         <li> <label>تدريس الأصوات المتنوعة للحروف (الفتح – الضم – الكسر - السكون):</label></li>
          <input type="radio" id="sounds_yes" name="sounds" value="نعم">
          <label for="sounds_yes" class="inline">نعم</label>
          <input type="radio" id="sounds_no" name="sounds" value="لا">
          <label for="sounds_no" class="inline">لا</label>
        </div>
        
        <div >
          <li><label>تدريس الحروف في حالاتها المتنوعة في بداية الكلمة ووسطها وآخرها:</label></li>
          <input type="radio" id="position_yes" name="position" value="نعم">
          <label for="position_yes" class="inline">نعم</label>
          <input type="radio" id="position_no" name="position" value="لا">
          <label for="position_no" class="inline">لا</label>
        </div>
        
        <div >
          <li><label>تدريس الحروف من خلال الكلمات:</label></li>
          <input type="radio" id="words_yes" name="words" value="نعم">
          <label for="words_yes" class="inline">نعم</label>
          <input type="radio" id="words_no" name="words" value="لا">
          <label for="words_no" class="inline">لا</label>
        </div>
                      
        
        <div >
          <li><label>التدريب على الحروف من خلال الكتابة:</label></li>
          <input type="radio" id="writing_yes" name="writing" value="نعم">
          <label for="writing_yes" class="inline">نعم</label>
          <input type="radio" id="writing_no" name="writing" value="لا">
          <label for="writing_no" class="inline">لا</label>
        </div>
        
        <div>
          <li><label>تكوين كلمات من مجموعة الحروف التي درسها:</label></li>
          <input type="radio" id="formation_yes" name="formation" value="نعم">
          <label for="formation_yes" class="inline">نعم</label>
          <input type="radio" id="formation_no" name="formation" value="لا">
          <label for="formation_no" class="inline">لا</label>
        </div>
                      </ul>
      </fieldset>
        
      
      <!-- المحور الثالث: استراتيجيات التدريس والوسائل -->
      <fieldset >
        <legend>المحور الثالث: استراتيجيات التدريس والوسائل</legend>
        
        <h3>(1) ما الاستراتجيات التي يستخدمها المعلم أثناء التدريس (يمكنك اختيار أكثر من واحدة):</h3>
        <div >
          <input type="checkbox" id="strategy1" name="strategies[]" value="التعلم التعاوني">
          <label for="strategy1" class="inline">التعلم التعاوني</label>
          <input type="checkbox" id="strategy2" name="strategies[]" value="المحاكاة">
          <label for="strategy2" class="inline">المحاكاة</label>
          <input type="checkbox" id="strategy3" name="strategies[]" value="النمذجة">
          <label for="strategy3" class="inline">النمذجة</label>
          <input type="checkbox" id="strategy4" name="strategies[]" value="القصص المسلسلة">
          <label for="strategy4" class="inline">القصص المسلسلة</label>
          <input type="checkbox" id="strategy5" name="strategies[]" value="تتبع الحرف">
          <label for="strategy5" class="inline">تتبع الحرف</label>
          <input type="checkbox" id="strategy6" name="strategies[]" value="الوقوف المتكرر">
          <label for="strategy6" class="inline">الوقوف المتكرر</label>
          <input type="checkbox" id="strategy7" name="strategies[]" value="البحث عن الحرف">
          <label for="strategy7" class="inline">البحث عن الحرف</label>
          <label for="strategyOther">أخري: تذكر </label>
          <input type="text" id="strategyOther" name="strategyOther" placeholder="اكتب استراتيجية أخرى">
        </div>
        
          <h3>(2) ما الألعاب اللغوية التي يستخدمها المعلم في التدريس (يمكنك اختيار أكثر من واحدة):</h3>
          
          <div >
          <input type="checkbox" id="game1" name="games[]" value="الأكواب المقلوبة">
          <label for="game1" class="inline">الأكواب المقلوبة</label>
          <input type="checkbox" id="game2" name="games[]" value="الكلمات المتقاطعة">
          <label for="game2" class="inline">الكلمات المتقاطعة</label>
          <input type="checkbox" id="game3" name="games[]" value="التصفيق للحرف">
          <label for="game3" class="inline">التصفيق للحرف</label>
          <input type="checkbox" id="game4" name="games[]" value="الفنان الصغير">
          <label for="game4" class="inline">الفنان الصغير</label>
          <input type="checkbox" id="game5" name="games[]" value="صندوق الحروف">
          <label for="game5" class="inline">صندوق الحروف</label>
          <input type="checkbox" id="game6" name="games[]" value="رفع الحل">
          <label for="game6" class="inline">رفع الحل</label>
          <input type="checkbox" id="game7" name="games[]" value="امرح مع الحرف">
          <label for="game7" class="inline">امرح مع الحرف</label>
          <label for="gameOther">أخري: تذكر </label>
          <input type="text" id="gameOther" name="gameOther" placeholder="اكتب لعبة لغوية أخرى">
        </div>
        
        
        <h3>(3) ما الأنشطة التفاعلية التي يستخدمها المعلم في التدريس (يمكنك اختيار أكثر من واحدة):</h3>
        <div >
      
          <input type="checkbox" id="activity1" name="activities[]" value="الرسم">
          <label for="activity1" class="inline">الرسم</label>
          <input type="checkbox" id="activity2" name="activities[]" value="الكتابة">
          <label for="activity2" class="inline">الكتابة</label>
          <input type="checkbox" id="activity3" name="activities[]" value="التلوين">
          <label for="activity3" class="inline">التلوين</label>
          <input type="checkbox" id="activity4" name="activities[]" value="اكتشاف الخطأ">
          <label for="activity4" class="inline">اكتشاف الخطأ</label>
          <input type="checkbox" id="activity5" name="activities[]" value="الترتيب">
          <label for="activity5" class="inline">الترتيب</label>
          <input type="checkbox" id="activity6" name="activities[]" value="الاستخراج">
          <label for="activity6" class="inline">الاستخراج</label>
          <input type="checkbox" id="activity7" name="activities[]" value="الإكمال">
          <label for="activity7" class="inline">الإكمال</label>
          <label for="activityOther">أخري: تذكر ..............</label>
          <input type="text" id="activityOther" name="activityOther" placeholder="اكتب نشاط تفاعلي آخر">
        </div>
        
        <h3>(4) ما الوسائل التعليمية التي يستخدمها المعلم في التدريس (يمكنك اختيار أكثر من واحدة):</h3>
        <div >
          <input type="checkbox" id="tool1" name="tools[]" value="السبورة">
          <label for="tool1" class="inline">السبورة</label>
          <input type="checkbox" id="tool2" name="tools[]" value="الأقلام الملونة">
          <label for="tool2" class="inline">الأقلام الملونة</label>
          <input type="checkbox" id="tool3" name="tools[]" value="الصور">
          <label for="tool3" class="inline">الصور</label>
          <input type="checkbox" id="tool4" name="tools[]" value="البطاقات">
          <label for="tool4" class="inline">البطاقات</label>
          <input type="checkbox" id="tool5" name="tools[]" value="الصحف">
          <label for="tool5" class="inline">الصحف</label>
          <input type="checkbox" id="tool6" name="tools[]" value="عجلة الكلمات">
          <label for="tool6" class="inline">عجلة الكلمات</label>
          <input type="checkbox" id="tool7" name="tools[]" value="مسرح العرائس">
          <label for="tool7" class="inline">مسرح العرائس</label>
          <label for="toolOther">أخري: تذكر ..............</label>
          <input type="text" id="toolOther" name="toolOther" placeholder="اكتب وسيلة تعليمية أخرى">
        </div>
      </fieldset>
      
      <!-- المحور الرابع: مدى تقدم مستوى التلاميذ في البرنامج -->
      <fieldset >
        <legend>المحور الرابع : مدى تقدم مستوى التلاميذ في البرنامج</legend>
        
        <h3>(1-أ) ما مدى اتقان التلاميذ أصوات الحروف (أ – ب- ت-ث):</h3>
        <div >
          <input type="radio" id="sounds_mastery_all" name="sounds_mastery" value="جميع التلاميذ">
          <label for="sounds_mastery_all" class="inline">جميع التلاميذ</label>
          <input type="radio" id="sounds_mastery_most" name="sounds_mastery" value="معظم التلاميذ">
          <label for="sounds_mastery_most" class="inline">معظم التلاميذ</label>
          <input type="radio" id="sounds_mastery_some" name="sounds_mastery" value="بعض التلاميذ">
          <label for="sounds_mastery_some" class="inline">بعض التلاميذ</label>
          <input type="radio" id="sounds_mastery_none" name="sounds_mastery" value="لا أحد من التلاميذ">
          <label for="sounds_mastery_none" class="inline">لا أحد من التلاميذ</label>
        </div>
        
        <h3>(1-ب) ما وسيلة التحقق من مستوى إتقان التلاميذ لأصوات الحروف السابقة (يمكنك اختيار أكثر من واحدة):</h3>
        <div >
          <input type="checkbox" id="check1" name="check1[]" value="اختبار قراءة">
          <label for="check1" class="inline">اختبار قراءة</label>
          <input type="checkbox" id="check2" name="check1[]" value="اختبار إملاء">
          <label for="check2" class="inline">اختبار إملاء</label>
          <input type="checkbox" id="check3" name="check1[]" value="مناقشة صفية">
          <label for="check3" class="inline">مناقشة صفية</label>
          <input type="checkbox" id="check4" name="check1[]" value="ملاحظة">
          <label for="check4" class="inline">ملاحظة</label>
          <label for="check1Other">أخري: تذكر </label>
          <input type="text" id="check1Other" name="check1Other" placeholder="اكتب وسيلة أخرى">
        </div>
        
        <h3>(2-أ) ما مدى اتقان التلاميذ أشكال الحروف (أ – ب- ت-ث):</h3>
        <div >
          <input type="radio" id="forms_mastery_all" name="forms_mastery" value="جميع التلاميذ">
          <label for="forms_mastery_all" class="inline">جميع التلاميذ</label>
          <input type="radio" id="forms_mastery_most" name="forms_mastery" value="معظم التلاميذ">
          <label for="forms_mastery_most" class="inline">معظم التلاميذ</label>
          <input type="radio" id="forms_mastery_some" name="forms_mastery" value="بعض التلاميذ">
          <label for="forms_mastery_some" class="inline">بعض التلاميذ</label>
          <input type="radio" id="forms_mastery_none" name="forms_mastery" value="لا أحد من التلاميذ">
          <label for="forms_mastery_none" class="inline">لا أحد من التلاميذ</label>
        </div>
        
        <h3>(2-ب) ما وسيلة التحقق من مستوى إتقان التلاميذ لأصوات الحروف السابقة (يمكنك اختيار أكثر من واحدة):</h3>
        <div >
          <input type="checkbox" id="check2_1" name="check2[]" value="اختبار قراءة">
          <label for="check2_1" class="inline">اختبار قراءة</label>
          <input type="checkbox" id="check2_2" name="check2[]" value="اختبار إملاء">
          <label for="check2_2" class="inline">اختبار إملاء</label>
          <input type="checkbox" id="check2_3" name="check2[]" value="مناقشة صفية">
          <label for="check2_3" class="inline">مناقشة صفية</label>
          <input type="checkbox" id="check2_4" name="check2[]" value="ملاحظة">
          <label for="check2_4" class="inline">ملاحظة</label>
          <label for="check2Other">أخري: تذكر </label>
          <input type="text" id="check2Other" name="check2Other" placeholder="اكتب وسيلة أخرى">
        </div>
      </fieldset>
      </div>
      
      <div class="buttons-container">
        <button type="submit" class="submit-button">إرسال</button>
        <button type="button" class="submit-button" onclick="window.location.href='https://www.google.com.eg/';">خروج</button>
      </div>
    </form>
  </div>
  <script>
    

    
</body>
</html>
